/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.client.gui.GuiNewKeyBindingList;
import java.util.function.Predicate;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.StatCollector;

public enum SearchType {
    ALL,
    CATEGORY_NAME,
    KEYBIND_NAME,
    KEY_NAME;


    public Predicate<GuiNewKeyBindingList.KeyEntry> getPredicate(String searchText) {
        switch (this) {
            case ALL: {
                return CATEGORY_NAME.getPredicate(searchText).or(KEYBIND_NAME.getPredicate(searchText)).or(KEY_NAME.getPredicate(searchText));
            }
            case CATEGORY_NAME: {
                return key -> StatCollector.func_74838_a((String)key.getKeybinding().func_151466_e()).toLowerCase().contains(searchText.toLowerCase());
            }
            case KEYBIND_NAME: {
                return key -> key.getKeyDesc().toLowerCase().contains(searchText.toLowerCase());
            }
            case KEY_NAME: {
                return key -> GameSettings.func_74298_c((int)key.getKeybinding().func_151463_i()).toLowerCase().contains(searchText.toLowerCase());
            }
        }
        throw new IllegalStateException();
    }
}

